/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.ClientSettings;
import com.microsoft.azure.servicebus.IMessageSession;
import com.microsoft.azure.servicebus.MessageReceiver;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.Utils;
import com.microsoft.azure.servicebus.primitives.MessagingEntityType;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import java.net.URI;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;

public class MessageSession
extends MessageReceiver
implements IMessageSession {
    private String requestedSessionId;

    MessageSession(URI namespaceEndpointURI, String entityPath, MessagingEntityType entityType, String requestedSessionId, ClientSettings clientSettings, ReceiveMode receiveMode) {
        super(namespaceEndpointURI, entityPath, entityType, clientSettings, receiveMode);
        this.requestedSessionId = requestedSessionId;
    }

    MessageSession(MessagingFactory messagingFactory, String entityPath, MessagingEntityType entityType, String requestedSessionId, ReceiveMode receiveMode) {
        super(messagingFactory, entityPath, entityType, receiveMode);
        this.requestedSessionId = requestedSessionId;
    }

    @Override
    protected final boolean isSessionReceiver() {
        return true;
    }

    @Override
    protected boolean isBrowsableSession() {
        return false;
    }

    @Override
    protected String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    @Override
    public Instant getLockedUntilUtc() {
        return this.getInternalReceiver().getSessionLockedUntilUtc();
    }

    @Override
    public void renewSessionLock() throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.renewSessionLockAsync());
    }

    @Override
    public CompletableFuture<Void> renewSessionLockAsync() {
        return this.getInternalReceiver().renewSessionLocksAsync();
    }

    @Override
    public void setState(byte[] sessionState) throws InterruptedException, ServiceBusException {
        Utils.completeFuture(this.setStateAsync(sessionState));
    }

    @Override
    public CompletableFuture<Void> setStateAsync(byte[] sessionState) {
        return this.getInternalReceiver().setSessionStateAsync(sessionState);
    }

    @Override
    public byte[] getState() throws InterruptedException, ServiceBusException {
        return Utils.completeFuture(this.getStateAsync());
    }

    @Override
    public CompletableFuture<byte[]> getStateAsync() {
        return this.getInternalReceiver().getSessionStateAsync();
    }

    @Override
    public String getSessionId() {
        return this.getInternalReceiver().getSessionId();
    }
}

