// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.microsoft.aad.msal4j;

import java.util.Map;
import java.util.Objects;

/**
 * Representation of a single user account. If modifying this object, ensure it is compliant with
 * cache persistent model
 */
class Account implements IAccount {

    String homeAccountId;
    String environment;
    String username;
    Map<String, ITenantProfile> tenantProfiles;

    Account(String homeAccountId, String environment, String username, Map<String, ITenantProfile> tenantProfiles) {
        this.homeAccountId = homeAccountId;
        this.environment = environment;
        this.username = username;
        this.tenantProfiles = tenantProfiles;
    }

    public Map<String, ITenantProfile> getTenantProfiles() {
        return tenantProfiles;
    }

    public String homeAccountId() {
        return this.homeAccountId;
    }

    public String environment() {
        return this.environment;
    }

    public String username() {
        return this.username;
    }

    void username(String username) {
        this.username = username;
    }

    //These methods are based on those generated by Lombok's @EqualsAndHashCode annotation.
    //They have the same functionality as the generated methods, but were refactored for readability.
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Account)) return false;

        Account other = (Account) o;

        return Objects.equals(homeAccountId(), other.homeAccountId());
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 59 + (this.homeAccountId == null ? 43 : this.homeAccountId.hashCode());
        return result;
    }
}
