/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.NonNull;

public class SilentParameters {
    @NonNull
    private Set<String> scopes;
    private IAccount account;
    private String authorityUrl;
    private boolean forceRefresh;

    private static SilentParametersBuilder builder() {
        return new SilentParametersBuilder();
    }

    public static SilentParametersBuilder builder(Set<String> scopes, IAccount account) {
        ParameterValidationUtils.validateNotNull("account", account);
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        return SilentParameters.builder().scopes(scopes).account(account);
    }

    public static SilentParametersBuilder builder(Set<String> scopes) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        return SilentParameters.builder().scopes(scopes);
    }

    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    public IAccount account() {
        return this.account;
    }

    public String authorityUrl() {
        return this.authorityUrl;
    }

    public boolean forceRefresh() {
        return this.forceRefresh;
    }

    @ConstructorProperties(value={"scopes", "account", "authorityUrl", "forceRefresh"})
    private SilentParameters(@NonNull Set<String> scopes, IAccount account, String authorityUrl, boolean forceRefresh) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.account = account;
        this.authorityUrl = authorityUrl;
        this.forceRefresh = forceRefresh;
    }

    public static class SilentParametersBuilder {
        private Set<String> scopes;
        private IAccount account;
        private String authorityUrl;
        private boolean forceRefresh;

        SilentParametersBuilder() {
        }

        public SilentParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public SilentParametersBuilder account(IAccount account) {
            this.account = account;
            return this;
        }

        public SilentParametersBuilder authorityUrl(String authorityUrl) {
            this.authorityUrl = authorityUrl;
            return this;
        }

        public SilentParametersBuilder forceRefresh(boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return this;
        }

        public SilentParameters build() {
            return new SilentParameters(this.scopes, this.account, this.authorityUrl, this.forceRefresh);
        }

        public String toString() {
            return "SilentParameters.SilentParametersBuilder(scopes=" + this.scopes + ", account=" + this.account + ", authorityUrl=" + this.authorityUrl + ", forceRefresh=" + this.forceRefresh + ")";
        }
    }
}

