/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationContentParser {
    private static final String MODULES_CONTENT_NAME = "modulesContent";
    @Expose(serialize=false, deserialize=true)
    @SerializedName(value="modulesContent")
    private Map<String, Map<String, Object>> modulesContent;
    private static final String DEVICE_CONTENT_NAME = "deviceContent";
    @Expose(serialize=false, deserialize=true)
    @SerializedName(value="deviceContent")
    private Map<String, Object> deviceContent;
    private static transient Gson gson = new Gson();

    public ConfigurationContentParser() {
    }

    public ConfigurationContentParser(String json) {
        ConfigurationContentParser configurationContentParser;
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("The provided json cannot be null or empty");
        }
        try {
            configurationContentParser = (ConfigurationContentParser)gson.fromJson(json, ConfigurationContentParser.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The provided json could not be parsed");
        }
        this.modulesContent = configurationContentParser.modulesContent;
        this.deviceContent = configurationContentParser.deviceContent;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public Map<String, Map<String, Object>> getModulesContent() {
        return this.modulesContent;
    }

    public void setModulesContent(Map<String, Map<String, Object>> modulesContent) {
        this.modulesContent = modulesContent;
    }

    public Map<String, Object> getDeviceContent() {
        return this.deviceContent;
    }

    public void setDeviceContent(Map<String, Object> deviceContent) {
        this.deviceContent = deviceContent;
    }

    public JsonElement toJsonElement() {
        JsonObject contentJson = new JsonObject();
        if (this.modulesContent != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<String, Map<String, Object>> entry : this.modulesContent.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            contentJson.add(MODULES_CONTENT_NAME, ParserUtility.mapToJsonElement(map));
        }
        if (this.deviceContent != null) {
            contentJson.add(DEVICE_CONTENT_NAME, ParserUtility.mapToJsonElement(this.deviceContent));
        }
        return contentJson;
    }
}

