/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.ConfigurationContentParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ConfigurationMetricsParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import java.util.Date;
import java.util.HashMap;

public class ConfigurationParser {
    private static final String CONFIGURATION_ID_NAME = "id";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="id")
    private String id;
    private static final String SCHEMA_VERSION_NAME = "schemaVersion";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="schemaVersion")
    private String schemaVersion;
    private static final String LABELS_NAME = "labels";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="labels")
    private HashMap<String, String> labels;
    private static final String CONTENT_NAME = "content";
    @Expose(serialize=false, deserialize=true)
    @SerializedName(value="content")
    private ConfigurationContentParser content;
    private static final String CONTENT_TYPE_NAME = "contentType";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="contentType")
    private String contentType;
    private static final String TARGET_CONDITION_NAME = "targetCondition";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="targetCondition")
    private String targetCondition;
    private static final String CREATED_TIME_UTC_NAME = "createdTimeUtc";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="createdTimeUtc")
    private String createdTimeUtcString;
    private transient Date createdTimeUtc;
    private static final String LAST_UPDATED_TIME_UTC_NAME = "lastUpdatedTimeUtc";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="lastUpdatedTimeUtc")
    private String lastUpdatedTimeUtcString;
    private transient Date lastUpdatedTimeUtc;
    private static final String PRIORITY_NAME = "priority";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="priority")
    private Integer priority;
    private static final String SYSTEM_METRICS_NAME = "systemMetrics";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="systemMetrics")
    private ConfigurationMetricsParser systemMetrics;
    private static final String METRICS_NAME = "metrics";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="metrics")
    private ConfigurationMetricsParser metrics;
    private static final String E_TAG_NAME = "etag";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="etag")
    private String eTag;
    private static transient Gson gson = new GsonBuilder().enableComplexMapKeySerialization().serializeNulls().create();

    public ConfigurationParser() {
    }

    public ConfigurationParser(String json) {
        ConfigurationParser configurationParser;
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("The provided json cannot be null or empty");
        }
        try {
            configurationParser = (ConfigurationParser)gson.fromJson(json, ConfigurationParser.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The provided json could not be parsed");
        }
        if (configurationParser.id == null || configurationParser.id.isEmpty()) {
            throw new IllegalArgumentException("The provided json must contain the field for configurationId and its value may not be empty");
        }
        this.id = configurationParser.id;
        this.schemaVersion = configurationParser.schemaVersion;
        this.labels = configurationParser.labels;
        this.content = configurationParser.content;
        this.contentType = configurationParser.contentType;
        this.targetCondition = configurationParser.targetCondition;
        this.priority = configurationParser.priority;
        this.systemMetrics = configurationParser.systemMetrics;
        this.metrics = configurationParser.metrics;
        this.eTag = configurationParser.eTag;
        if (configurationParser.createdTimeUtcString != null) {
            this.createdTimeUtcString = configurationParser.createdTimeUtcString;
            this.createdTimeUtc = ParserUtility.getDateTimeUtc(configurationParser.createdTimeUtcString);
        }
        if (configurationParser.lastUpdatedTimeUtcString != null) {
            this.lastUpdatedTimeUtcString = configurationParser.lastUpdatedTimeUtcString;
            this.lastUpdatedTimeUtc = ParserUtility.getDateTimeUtc(configurationParser.lastUpdatedTimeUtcString);
        }
    }

    public String toJson() {
        if (this.createdTimeUtc != null) {
            this.createdTimeUtcString = ParserUtility.getDateStringFromDate(this.createdTimeUtc);
        }
        if (this.lastUpdatedTimeUtc != null) {
            this.lastUpdatedTimeUtcString = ParserUtility.getDateStringFromDate(this.lastUpdatedTimeUtc);
        }
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        JsonObject jsonObject = gson.toJsonTree((Object)this).getAsJsonObject();
        if (this.content != null) {
            jsonObject.add(CONTENT_NAME, this.content.toJsonElement());
        }
        return jsonObject.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) throws IllegalArgumentException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Configuration Id cannot not be null");
        }
        this.id = id;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public HashMap<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(HashMap<String, String> labels) throws IllegalArgumentException {
        this.labels = labels;
    }

    public ConfigurationContentParser getContent() {
        return this.content;
    }

    public void setContent(ConfigurationContentParser content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getTargetCondition() {
        return this.targetCondition;
    }

    public void setTargetCondition(String targetCondition) {
        this.targetCondition = targetCondition;
    }

    public Date getCreatedTimeUtc() {
        return this.createdTimeUtc;
    }

    public void setCreatedTimeUtc(Date createdTimeUtc) {
        this.createdTimeUtc = createdTimeUtc;
        this.createdTimeUtcString = createdTimeUtc == null ? null : ParserUtility.getDateStringFromDate(createdTimeUtc);
    }

    public Date getLastUpdatedTimeUtc() {
        return this.lastUpdatedTimeUtc;
    }

    public void setLastUpdatedTimeUtc(Date lastUpdatedTimeUtc) {
        this.lastUpdatedTimeUtc = lastUpdatedTimeUtc;
        this.lastUpdatedTimeUtcString = lastUpdatedTimeUtc == null ? null : ParserUtility.getDateStringFromDate(lastUpdatedTimeUtc);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public ConfigurationMetricsParser getSystemMetrics() {
        return this.systemMetrics;
    }

    public void setSystemMetrics(ConfigurationMetricsParser systemMetrics) {
        this.systemMetrics = systemMetrics;
    }

    public ConfigurationMetricsParser getMetrics() {
        return this.metrics;
    }

    public void setMetrics(ConfigurationMetricsParser metrics) {
        this.metrics = metrics;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }
}

