/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import java.util.Date;

public class FileUploadNotificationParser {
    private static final String DEVICE_ID_TAG = "deviceId";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="deviceId")
    private String deviceId = null;
    private static final String BLOB_URI_TAG = "blobUri";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="blobUri")
    private String blobUri = null;
    private static final String BLOB_NAME_TAG = "blobName";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="blobName")
    private String blobName = null;
    private static final String LAST_UPDATED_TIME_TAG = "lastUpdatedTime";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="lastUpdatedTime")
    private String lastUpdatedTime = null;
    private transient Date lastUpdatedTimeDate;
    private static final String BLOB_SIZE_IN_BYTES_TAG = "blobSizeInBytes";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="blobSizeInBytes")
    private Long blobSizeInBytes = null;
    private static final String ENQUEUED_TIME_UTC_TAG = "enqueuedTimeUtc";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="enqueuedTimeUtc")
    private String enqueuedTimeUtc = null;
    private transient Date enqueuedTimeUtcDate;

    public FileUploadNotificationParser(String json) throws IllegalArgumentException {
        FileUploadNotificationParser fileUploadNotificationParser;
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        ParserUtility.validateStringUTF8(json);
        try {
            fileUploadNotificationParser = (FileUploadNotificationParser)gson.fromJson(json, FileUploadNotificationParser.class);
        }
        catch (Exception malformed) {
            throw new IllegalArgumentException("Malformed json", malformed);
        }
        ParserUtility.validateStringUTF8(fileUploadNotificationParser.deviceId);
        ParserUtility.validateStringUTF8(fileUploadNotificationParser.blobUri);
        ParserUtility.validateBlobName(fileUploadNotificationParser.blobName);
        ParserUtility.validateStringUTF8(fileUploadNotificationParser.enqueuedTimeUtc);
        ParserUtility.validateStringUTF8(fileUploadNotificationParser.lastUpdatedTime);
        if (fileUploadNotificationParser.blobSizeInBytes == null) {
            fileUploadNotificationParser.blobSizeInBytes = 0L;
        } else if (fileUploadNotificationParser.blobSizeInBytes < 0L) {
            throw new IllegalArgumentException("negative size");
        }
        this.deviceId = fileUploadNotificationParser.deviceId;
        this.blobUri = fileUploadNotificationParser.blobUri;
        this.blobName = fileUploadNotificationParser.blobName;
        this.lastUpdatedTime = fileUploadNotificationParser.lastUpdatedTime;
        this.enqueuedTimeUtc = fileUploadNotificationParser.enqueuedTimeUtc;
        this.blobSizeInBytes = fileUploadNotificationParser.blobSizeInBytes;
        this.enqueuedTimeUtcDate = ParserUtility.getDateTimeUtc(this.enqueuedTimeUtc);
        this.lastUpdatedTimeDate = ParserUtility.stringToDateTimeOffset(this.lastUpdatedTime);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getBlobUri() {
        return this.blobUri;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTimeDate;
    }

    public Date getEnqueuedTimeUtc() {
        return this.enqueuedTimeUtcDate;
    }

    public Long getBlobSizeInBytesTag() {
        return this.blobSizeInBytes;
    }

    FileUploadNotificationParser() {
    }
}

