/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.List;

public final class AutoDetectSourceLanguageConfig
implements AutoCloseable {
    private SafeHandle configHandle = null;
    private boolean disposed = false;

    public static AutoDetectSourceLanguageConfig fromOpenRange() {
        IntRef autoDetectLangConfigRef = new IntRef(0L);
        Contracts.throwIfFail(AutoDetectSourceLanguageConfig.fromOpenRange(autoDetectLangConfigRef));
        return new AutoDetectSourceLanguageConfig(autoDetectLangConfigRef.getValue());
    }

    public static AutoDetectSourceLanguageConfig fromLanguages(List<String> languages) {
        if (languages == null || languages.size() == 0) {
            throw new IllegalArgumentException("languages cannot be null or empty");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < languages.size(); ++i) {
            sb.append(languages.get(i));
            if (i == languages.size() - 1) continue;
            sb.append(",");
        }
        IntRef langConfigRef = new IntRef(0L);
        Contracts.throwIfFail(AutoDetectSourceLanguageConfig.fromLanguages(langConfigRef, sb.toString()));
        return new AutoDetectSourceLanguageConfig(langConfigRef.getValue());
    }

    public static AutoDetectSourceLanguageConfig fromSourceLanguageConfigs(List<SourceLanguageConfig> sourceLanguageConfigs) {
        if (sourceLanguageConfigs == null || sourceLanguageConfigs.size() == 0) {
            throw new IllegalArgumentException("sourceLanguageConfigs cannot be null or empty");
        }
        boolean isFirst = true;
        IntRef autoDetectLangConfigRef = new IntRef(0L);
        for (SourceLanguageConfig sourceLanguageConfig : sourceLanguageConfigs) {
            Contracts.throwIfNull(sourceLanguageConfig, "sourceLanguageConfig cannot be null");
            if (isFirst) {
                Contracts.throwIfFail(AutoDetectSourceLanguageConfig.createFromSourceLangConfig(autoDetectLangConfigRef, sourceLanguageConfig.getImpl()));
                isFirst = false;
                continue;
            }
            Contracts.throwIfFail(AutoDetectSourceLanguageConfig.addSourceLangConfigToAutoDetectSourceLangConfig(autoDetectLangConfigRef, sourceLanguageConfig.getImpl()));
        }
        return new AutoDetectSourceLanguageConfig(autoDetectLangConfigRef.getValue());
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.configHandle != null) {
            this.configHandle.close();
            this.configHandle = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.configHandle;
    }

    private AutoDetectSourceLanguageConfig(long handleValue) {
        Contracts.throwIfNull(handleValue, "handleValue");
        this.configHandle = new SafeHandle(handleValue, SafeHandleType.AutoDetectSourceLanguageConfig);
    }

    private static final native long fromOpenRange(IntRef var0);

    private static final native long fromLanguages(IntRef var0, String var1);

    private static final native long createFromSourceLangConfig(IntRef var0, SafeHandle var1);

    private static final native long addSourceLangConfigToAutoDetectSourceLangConfig(IntRef var0, SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

