/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class ConnectionMessage
implements AutoCloseable {
    private SafeHandle messageHandle = null;
    private PropertyCollection properties = null;
    private byte[] binaryMessage = null;

    ConnectionMessage(long message) {
        Contracts.throwIfNull(message, "message is null");
        this.messageHandle = new SafeHandle(message, SafeHandleType.ConnectionMessage);
        IntRef propertyHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.messageHandle, propertyHandle));
        this.properties = new PropertyCollection(propertyHandle);
    }

    public String getPath() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties.getProperty("connection.message.path");
    }

    public String getTextMessage() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties.getProperty("connection.message.text.message");
    }

    public byte[] getBinaryMessage() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        if (this.binaryMessage == null) {
            IntRef hr = new IntRef(0L);
            this.binaryMessage = this.getMessageData(this.messageHandle, hr);
            Contracts.throwIfFail(hr.getValue());
        }
        return this.binaryMessage;
    }

    public boolean isBinaryMessage() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties.getProperty("connection.message.type").equals("binary");
    }

    public boolean isTextMessage() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties.getProperty("connection.message.type").equals("text");
    }

    public String toString() {
        String output = "";
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        if (this.isTextMessage()) {
            output = "Path: " + this.getPath() + ", Type: text, Message: " + this.getTextMessage();
        } else if (this.isBinaryMessage()) {
            output = "Path: " + this.getPath() + ", Type: binary, Size: " + (this.getBinaryMessage() == null ? 0 : this.getBinaryMessage().length) + " bytes";
        }
        return output;
    }

    public PropertyCollection getProperties() {
        Contracts.throwIfNull(this.messageHandle, "messageHandle is null");
        return this.properties;
    }

    @Override
    public void close() {
        if (this.messageHandle != null) {
            this.messageHandle.close();
            this.messageHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
        this.binaryMessage = null;
    }

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    private final native byte[] getMessageData(SafeHandle var1, IntRef var2);
}

