/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisOutputFormat;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.TelemetryManager;

public final class HybridSpeechConfig
implements AutoCloseable {
    SpeechConfig config = null;
    private boolean disposed = false;

    HybridSpeechConfig(long handleValue) {
        this.config = new SpeechConfig(handleValue);
        TelemetryManager.getSingleton();
    }

    public static final HybridSpeechConfig fromConfigs(SpeechConfig cloudSpeechConfig, EmbeddedSpeechConfig embeddedSpeechConfig) {
        Contracts.throwIfNull(cloudSpeechConfig, "cloudSpeechConfig");
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(HybridSpeechConfig.createHybridSpeechConfig(configRef, cloudSpeechConfig.getImpl(), embeddedSpeechConfig.config.getImpl()));
        HybridSpeechConfig hybridSpeechConfig = new HybridSpeechConfig(configRef.getValue());
        return hybridSpeechConfig;
    }

    public final void setSpeechRecognitionOutputFormat(OutputFormat value) {
        this.config.setOutputFormat(value);
    }

    public final OutputFormat getSpeechRecognitionOutputFormat() {
        return this.config.getOutputFormat();
    }

    public final void setSpeechSynthesisOutputFormat(SpeechSynthesisOutputFormat value) {
        this.config.setSpeechSynthesisOutputFormat(value);
    }

    public final String getSpeechSynthesisOutputFormat() {
        return this.config.getSpeechSynthesisOutputFormat();
    }

    public void setProperty(String name, String value) {
        this.config.setProperty(name, value);
    }

    public void setProperty(PropertyId id, String value) {
        this.config.setProperty(id, value);
    }

    public String getProperty(String name) {
        return this.config.getProperty(name);
    }

    public String getProperty(PropertyId id) {
        return this.config.getProperty(id);
    }

    @Override
    public final void close() {
        if (this.disposed) {
            return;
        }
        if (this.config != null) {
            this.config.close();
            this.config = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        Contracts.throwIfNull(this.config, "config");
        return this.config.getImpl();
    }

    private static final native long createHybridSpeechConfig(IntRef var0, SafeHandle var1, SafeHandle var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

