/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.KeywordRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.KeywordRecognitionModel;
import com.microsoft.cognitiveservices.speech.KeywordRecognitionResult;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public final class KeywordRecognizer
implements AutoCloseable {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<KeywordRecognitionEventArgs> recognized = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechRecognitionCanceledEventArgs> canceled = new EventHandlerImpl(this.eventCounter);
    static Set<KeywordRecognizer> keywordRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle recoHandle = new SafeHandle(0L, SafeHandleType.KeywordRecognizer);
    private AudioConfig audioInputKeepAlive = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    public KeywordRecognizer(AudioConfig audioConfig) {
        SafeHandle audioConfigHandle = audioConfig == null ? null : audioConfig.getImpl();
        Contracts.throwIfFail(this.createKeywordRecognizerFromConfig(this.recoHandle, audioConfigHandle));
        this.audioInputKeepAlive = audioConfig;
        this.initialize();
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<KeywordRecognitionResult> recognizeOnceAsync(final KeywordRecognitionModel model) {
        return AsyncThreadService.submit(new Callable<KeywordRecognitionResult>(){

            @Override
            public KeywordRecognitionResult call() {
                IntRef result = new IntRef(0L);
                Contracts.throwIfFail(KeywordRecognizer.this.recognizeOnce(KeywordRecognizer.this.recoHandle, model.getImpl(), result));
                return new KeywordRecognitionResult(result.getValue());
            }
        });
    }

    public Future<Void> stopRecognitionAsync() {
        final KeywordRecognizer thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.stopRecognition(KeywordRecognizer.this.recoHandle);
                    }
                };
                return null;
            }
        });
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    private void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.recoHandle != null) {
                this.recoHandle.close();
                this.recoHandle = null;
            }
            this.audioInputKeepAlive = null;
            keywordRecognizerObjects.remove(this);
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    public SafeHandle getImpl() {
        return this.recoHandle;
    }

    private void initialize() {
        final KeywordRecognizer _this = this;
        AsyncThreadService.initialize();
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                keywordRecognizerObjects.add(_this);
                Contracts.throwIfFail(KeywordRecognizer.this.recognizedSetCallback(_this.recoHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                keywordRecognizerObjects.add(_this);
                Contracts.throwIfFail(KeywordRecognizer.this.canceledSetCallback(_this.recoHandle.getValue()));
            }
        });
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(_this.recoHandle, propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    private void recognizedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            KeywordRecognitionEventArgs resultEventArg = new KeywordRecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<KeywordRecognitionEventArgs> handler = this.recognized;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionCanceledEventArgs resultEventArg = new SpeechRecognitionCanceledEventArgs(eventArgs, true);
            EventHandlerImpl<SpeechRecognitionCanceledEventArgs> handler = this.canceled;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createKeywordRecognizerFromConfig(SafeHandle var1, SafeHandle var2);

    private final native long recognizeOnce(SafeHandle var1, SafeHandle var2, IntRef var3);

    private final native long stopRecognition(SafeHandle var1);

    private final native long recognizedSetCallback(long var1);

    private final native long canceledSetCallback(long var1);

    private final native long getPropertyBagFromRecognizerHandle(SafeHandle var1, IntRef var2);
}

