/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.concurrent.atomic.AtomicInteger;

public class Recognizer
implements AutoCloseable {
    protected AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<SessionEventArgs> sessionStarted = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SessionEventArgs> sessionStopped = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<RecognitionEventArgs> speechStartDetected = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<RecognitionEventArgs> speechEndDetected = new EventHandlerImpl(this.eventCounter);
    private SafeHandle recoHandle = null;
    protected boolean disposed = false;
    private AudioConfig audioInputKeepAlive = null;
    private final Object recognizerLock = new Object();
    private int activeAsyncRecognitionCounter = 0;

    protected Recognizer(AudioConfig audioInput) {
        AsyncThreadService.initialize();
        this.recoHandle = new SafeHandle(0L, SafeHandleType.Recognizer);
        this.audioInputKeepAlive = audioInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.recognizerLock;
        synchronized (object) {
            if (this.activeAsyncRecognitionCounter != 0) {
                throw new IllegalStateException("Cannot dispose a recognizer while async recognition is running. Await async recognitions to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public SafeHandle getImpl() {
        return this.recoHandle;
    }

    protected void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (this.recoHandle != null) {
            this.recoHandle.close();
            this.recoHandle = null;
        }
        AsyncThreadService.shutdown();
        this.audioInputKeepAlive = null;
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAsyncRecognitionAction(Runnable recoImplAction) {
        Object object = this.recognizerLock;
        synchronized (object) {
            ++this.activeAsyncRecognitionCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            recoImplAction.run();
        }
        finally {
            object = this.recognizerLock;
            synchronized (object) {
                --this.activeAsyncRecognitionCounter;
            }
        }
    }

    protected long recognize() {
        Contracts.throwIfNull(this.recoHandle, "Invalid recognizer handle");
        IntRef result = new IntRef(0L);
        Contracts.throwIfFail(this.recognizeOnce(this.recoHandle, result));
        return result.getValue();
    }

    protected void sessionStartedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SessionEventArgs arg = new SessionEventArgs(eventArgs, true);
            EventHandlerImpl<SessionEventArgs> handler = this.sessionStarted;
            if (handler != null) {
                handler.fireEvent(this, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void sessionStoppedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            SessionEventArgs arg = new SessionEventArgs(eventArgs, true);
            EventHandlerImpl<SessionEventArgs> handler = this.sessionStopped;
            if (handler != null) {
                handler.fireEvent(this, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void speechStartDetectedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            RecognitionEventArgs arg = new RecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<RecognitionEventArgs> handler = this.speechStartDetected;
            if (handler != null) {
                handler.fireEvent(this, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void speechEndDetectedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            RecognitionEventArgs arg = new RecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<RecognitionEventArgs> handler = this.speechEndDetected;
            if (handler != null) {
                handler.fireEvent(this, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final native long startContinuousRecognition(SafeHandle var1);

    protected final native long stopContinuousRecognition(SafeHandle var1);

    protected final native long startKeywordRecognition(SafeHandle var1, SafeHandle var2);

    protected final native long stopKeywordRecognition(SafeHandle var1);

    protected final native long recognizingSetCallback(long var1);

    protected final native long recognizedSetCallback(long var1);

    protected final native long canceledSetCallback(long var1);

    protected final native long sessionStartedSetCallback(long var1);

    protected final native long sessionStoppedSetCallback(long var1);

    protected final native long speechStartDetectedSetCallback(long var1);

    protected final native long speechEndDetectedSetCallback(long var1);

    protected final native long getPropertyBagFromRecognizerHandle(SafeHandle var1, IntRef var2);

    private final native long recognizeOnce(SafeHandle var1, IntRef var2);
}

