/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.ProfanityOption;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ServicePropertyChannel;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisOutputFormat;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.lang.reflect.Method;
import java.net.URI;

public class SpeechConfig
implements AutoCloseable {
    public static Class<?> speechConfigClass;
    private SafeHandle speechConfigHandle = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    protected SpeechConfig(long handleValue) {
        Contracts.throwIfNull(handleValue, "handleValue");
        this.speechConfigHandle = new SafeHandle(handleValue, SafeHandleType.SpeechConfig);
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.speechConfigHandle, propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
        this.propertyHandle.setProperty("AZAC-SDK-PROGRAMMING-LANGUAGE", "Java");
    }

    public static SpeechConfig fromSubscription(String subscriptionKey, String region) {
        Contracts.throwIfIllegalSubscriptionKey(subscriptionKey, "subscriptionKey");
        Contracts.throwIfNullOrWhitespace(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromSubscription(configRef, subscriptionKey, region));
        return new SpeechConfig(configRef.getValue());
    }

    public static SpeechConfig fromAuthorizationToken(String authorizationToken, String region) {
        Contracts.throwIfNullOrWhitespace(authorizationToken, "authorizationToken");
        Contracts.throwIfNullOrWhitespace(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromAuthorizationToken(configRef, authorizationToken, region));
        return new SpeechConfig(configRef.getValue());
    }

    public static SpeechConfig fromEndpoint(URI endpoint, String subscriptionKey) {
        Contracts.throwIfNull(endpoint, "endpoint");
        if (subscriptionKey == null) {
            throw new NullPointerException("subscriptionKey");
        }
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromEndpoint(configRef, endpoint.toString(), subscriptionKey));
        return new SpeechConfig(configRef.getValue());
    }

    public static SpeechConfig fromEndpoint(URI endpoint) {
        Contracts.throwIfNull(endpoint, "endpoint");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromEndpoint(configRef, endpoint.toString(), null));
        return new SpeechConfig(configRef.getValue());
    }

    public static SpeechConfig fromHost(URI host, String subscriptionKey) {
        Contracts.throwIfNull(host, "host");
        if (subscriptionKey == null) {
            throw new NullPointerException("subscriptionKey");
        }
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromHost(configRef, host.toString(), subscriptionKey));
        return new SpeechConfig(configRef.getValue());
    }

    public static SpeechConfig fromHost(URI host) {
        Contracts.throwIfNull(host, "host");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechConfig.fromHost(configRef, host.toString(), null));
        return new SpeechConfig(configRef.getValue());
    }

    public void setAuthorizationToken(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, value);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public void setSpeechRecognitionLanguage(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_RecoLanguage, value);
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public void setOutputFormat(OutputFormat format) {
        String value = "false";
        if (format == OutputFormat.Detailed) {
            value = "true";
        }
        this.propertyHandle.setProperty(PropertyId.SpeechServiceResponse_RequestDetailedResultTrueFalse, value);
    }

    public OutputFormat getOutputFormat() {
        String result = this.propertyHandle.getProperty(PropertyId.SpeechServiceResponse_RequestDetailedResultTrueFalse);
        return result.equals("true") ? OutputFormat.Detailed : OutputFormat.Simple;
    }

    public void setEndpointId(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_EndpointId, value);
    }

    public String getEndpointId() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_EndpointId);
    }

    public void setSpeechSynthesisLanguage(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_SynthLanguage, value);
    }

    public String getSpeechSynthesisLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_SynthLanguage);
    }

    public void setSpeechSynthesisVoiceName(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_SynthVoice, value);
    }

    public String getSpeechSynthesisVoiceName() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_SynthVoice);
    }

    public void setSpeechSynthesisOutputFormat(SpeechSynthesisOutputFormat value) {
        Contracts.throwIfFail(this.setAudioOutputFormat(this.speechConfigHandle, value.getValue()));
    }

    public String getSpeechSynthesisOutputFormat() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_SynthOutputFormat);
    }

    public void setProxy(String proxyHostName, int proxyPort, String proxyUserName, String proxyPassword) {
        Contracts.throwIfNullOrWhitespace(proxyHostName, "proxyHostName");
        Contracts.throwIfNull(proxyUserName, "proxyUserName");
        Contracts.throwIfNull(proxyPassword, "proxyPassword");
        if (proxyPort <= 0) {
            throw new IllegalArgumentException("invalid proxy port");
        }
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_ProxyHostName, proxyHostName);
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_ProxyPort, Integer.toString(proxyPort));
        if (proxyUserName != "") {
            this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_ProxyUserName, proxyUserName);
        }
        if (proxyPassword != "") {
            this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_ProxyPassword, proxyPassword);
        }
    }

    public void setProperty(String name, String value) {
        Contracts.throwIfNullOrWhitespace(name, "name");
        this.propertyHandle.setProperty(name, value);
    }

    public void setProperty(PropertyId id, String value) {
        this.propertyHandle.setProperty(id, value);
    }

    public String getProperty(String name) {
        return this.propertyHandle.getProperty(name);
    }

    public String getProperty(PropertyId id) {
        return this.propertyHandle.getProperty(id);
    }

    public void setServiceProperty(String name, String value, ServicePropertyChannel channel) {
        Contracts.throwIfNullOrWhitespace(name, "name");
        Contracts.throwIfNullOrWhitespace(value, "value");
        Contracts.throwIfFail(this.setServiceProperty(this.speechConfigHandle, name, value, channel.getValue()));
    }

    public void setProfanity(ProfanityOption profanity) {
        Contracts.throwIfFail(this.setProfanity(this.speechConfigHandle, profanity.getValue()));
    }

    public void enableAudioLogging() {
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_EnableAudioLogging, "true");
    }

    public void requestWordLevelTimestamps() {
        this.propertyHandle.setProperty(PropertyId.SpeechServiceResponse_RequestWordLevelTimestamps, "true");
    }

    public void enableDictation() {
        this.propertyHandle.setProperty(PropertyId.SpeechServiceConnection_RecoMode, "DICTATION");
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.speechConfigHandle != null) {
            this.speechConfigHandle.close();
            this.speechConfigHandle = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.speechConfigHandle;
    }

    private static final native long fromSubscription(IntRef var0, String var1, String var2);

    private static final native long fromAuthorizationToken(IntRef var0, String var1, String var2);

    private static final native long fromEndpoint(IntRef var0, String var1, String var2);

    private static final native long fromHost(IntRef var0, String var1, String var2);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    private final native long setProfanity(SafeHandle var1, int var2);

    private final native long setServiceProperty(SafeHandle var1, String var2, String var3, int var4);

    private final native long setAudioOutputFormat(SafeHandle var1, int var2);

    private static final native void setTempDirectory(String var0);

    static {
        block6: {
            speechConfigClass = null;
            try {
                Class<?> ncl = Class.forName("com.microsoft.cognitiveservices.speech.NativeLibraryLoader");
                if (ncl != null) {
                    try {
                        Method nclm = ncl.getMethod("loadNativeBinding", new Class[0]);
                        nclm.invoke(null, new Object[0]);
                    }
                    catch (Exception exception) {}
                    break block6;
                }
                throw new NullPointerException("no native loader available");
            }
            catch (Error ex) {
                System.loadLibrary("Microsoft.CognitiveServices.Speech.java.bindings");
                System.loadLibrary("Microsoft.CognitiveServices.Speech.core");
            }
            catch (Exception ex2) {
                System.loadLibrary("Microsoft.CognitiveServices.Speech.java.bindings");
                System.loadLibrary("Microsoft.CognitiveServices.Speech.core");
            }
        }
        SpeechConfig.setTempDirectory(System.getProperty("java.io.tmpdir"));
        speechConfigClass = SpeechConfig.class;
    }
}

