/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;

public class SpeechRecognitionEventArgs
extends RecognitionEventArgs {
    private SpeechRecognitionResult result;

    public SpeechRecognitionEventArgs(long eventArgs) {
        super(eventArgs);
        this.storeEventData(false);
    }

    public SpeechRecognitionEventArgs(long eventArgs, boolean dispose) {
        super(eventArgs);
        this.storeEventData(dispose);
    }

    public final SpeechRecognitionResult getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.getSessionId() + " ResultId:" + this.result.getResultId() + " Reason:" + (Object)((Object)this.result.getReason()) + " Recognized text:<" + this.result.getText() + ">.";
    }

    private void storeEventData(boolean disposeNativeResources) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef resultHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getRecognitionResult(this.eventHandle, resultHandle));
        this.result = new SpeechRecognitionResult(resultHandle.getValue());
        Contracts.throwIfNull(this.getSessionId(), "SessionId");
        if (disposeNativeResources) {
            super.close();
        }
    }
}

