/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SpeechSynthesisVisemeEventArgs {
    private String resultId;
    private long audioOffset;
    private long visemeId;
    private String animation;

    SpeechSynthesisVisemeEventArgs(long eventArgs) {
        Contracts.throwIfNull(eventArgs, "eventArgs");
        SafeHandle eventHandle = new SafeHandle(eventArgs, SafeHandleType.SynthesisEvent);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(eventHandle, stringRef));
        this.resultId = stringRef.getValue();
        IntRef audioOffsetRef = new IntRef(0L);
        IntRef visemeIdRef = new IntRef(0L);
        Contracts.throwIfFail(this.getVisemeEventValues(eventHandle, audioOffsetRef, visemeIdRef));
        this.audioOffset = audioOffsetRef.getValue();
        this.visemeId = visemeIdRef.getValue();
        Contracts.throwIfFail(this.getAnimationFromHandle(eventHandle, stringRef));
        this.animation = stringRef.getValue();
        eventHandle.close();
    }

    public String getResultId() {
        return this.resultId;
    }

    public long getAudioOffset() {
        return this.audioOffset;
    }

    public long getVisemeId() {
        return this.visemeId;
    }

    public String getAnimation() {
        return this.animation;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getVisemeEventValues(SafeHandle var1, IntRef var2, IntRef var3);

    private final native long getAnimationFromHandle(SafeHandle var1, StringRef var2);
}

