/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.AutoDetectSourceLanguageConfig;
import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.HybridSpeechConfig;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisBookmarkEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisResult;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisVisemeEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisWordBoundaryEventArgs;
import com.microsoft.cognitiveservices.speech.SynthesisVoicesResult;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class SpeechSynthesizer
implements AutoCloseable {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<SpeechSynthesisEventArgs> SynthesisStarted = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisEventArgs> Synthesizing = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisEventArgs> SynthesisCompleted = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisEventArgs> SynthesisCanceled = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisWordBoundaryEventArgs> WordBoundary = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisVisemeEventArgs> VisemeReceived = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<SpeechSynthesisBookmarkEventArgs> BookmarkReached = new EventHandlerImpl(this.eventCounter);
    private static Set<SpeechSynthesizer> s_speechSynthesizerObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle synthHandle = null;
    private PropertyCollection propertyHandle;
    private boolean disposed = false;
    private static Integer disposeWaitingTime = 100;
    private final Object synthesizerLock = new Object();
    private int activeAsyncSynthesisCounter = 0;
    private AudioConfig audioOutputKeepAlive = null;

    public SpeechSynthesizer(SpeechConfig speechConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        this.synthHandle = new SafeHandle(0L, SafeHandleType.Synthesizer);
        AudioConfig audioConfig = AudioConfig.fromDefaultSpeakerOutput();
        Contracts.throwIfFail(this.createSpeechSynthesizerFromConfig(this.synthHandle, speechConfig.getImpl(), audioConfig.getImpl()));
        Contracts.throwIfNull(this.synthHandle.getValue(), "synthHandle");
        audioConfig.close();
        this.initialize();
    }

    public SpeechSynthesizer(SpeechConfig speechConfig, AudioConfig audioConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        this.synthHandle = new SafeHandle(0L, SafeHandleType.Synthesizer);
        Contracts.throwIfFail(this.createSpeechSynthesizerFromConfig(this.synthHandle, speechConfig.getImpl(), audioConfig == null ? null : audioConfig.getImpl()));
        Contracts.throwIfNull(this.synthHandle.getValue(), "synthHandle");
        this.audioOutputKeepAlive = audioConfig;
        this.initialize();
    }

    public SpeechSynthesizer(SpeechConfig speechConfig, AutoDetectSourceLanguageConfig autoDetectSourceLangConfig, AudioConfig audioConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(autoDetectSourceLangConfig, "autoDetectSourceLangConfig");
        this.synthHandle = new SafeHandle(0L, SafeHandleType.Synthesizer);
        Contracts.throwIfFail(this.createSpeechSynthesizerFromAutoDetectSourceLangConfig(this.synthHandle, speechConfig.getImpl(), autoDetectSourceLangConfig.getImpl(), audioConfig == null ? null : audioConfig.getImpl()));
        Contracts.throwIfNull(this.synthHandle.getValue(), "synthHandle");
        this.audioOutputKeepAlive = audioConfig;
        this.initialize();
    }

    public SpeechSynthesizer(EmbeddedSpeechConfig embeddedSpeechConfig) {
        this(embeddedSpeechConfig.config);
    }

    public SpeechSynthesizer(HybridSpeechConfig hybridSpeechConfig) {
        this(hybridSpeechConfig.config);
    }

    public SpeechSynthesizer(EmbeddedSpeechConfig embeddedSpeechConfig, AudioConfig audioConfig) {
        this(embeddedSpeechConfig.config, audioConfig);
    }

    public SpeechSynthesizer(HybridSpeechConfig hybridSpeechConfig, AudioConfig audioConfig) {
        this(hybridSpeechConfig.config, audioConfig);
    }

    public SpeechSynthesisResult SpeakText(String text) {
        IntRef resultRef = new IntRef(0L);
        Contracts.throwIfFail(this.speakText(this.synthHandle, text, resultRef));
        return new SpeechSynthesisResult(resultRef);
    }

    public SpeechSynthesisResult SpeakSsml(String ssml) {
        IntRef resultRef = new IntRef(0L);
        Contracts.throwIfFail(this.speakSsml(this.synthHandle, ssml, resultRef));
        return new SpeechSynthesisResult(resultRef);
    }

    public Future<SpeechSynthesisResult> SpeakTextAsync(String text) {
        final SpeechSynthesizer thisSynth = this;
        final String finalText = text;
        return AsyncThreadService.submit(new Callable<SpeechSynthesisResult>(){

            @Override
            public SpeechSynthesisResult call() {
                final SpeechSynthesisResult[] result = new SpeechSynthesisResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef resultRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.speakText(SpeechSynthesizer.this.synthHandle, finalText, resultRef));
                        result[0] = new SpeechSynthesisResult(resultRef);
                    }
                };
                thisSynth.doAsyncSynthesisAction(runnable);
                return result[0];
            }
        });
    }

    public Future<SpeechSynthesisResult> SpeakSsmlAsync(String ssml) {
        final SpeechSynthesizer thisSynth = this;
        final String finalSsml = ssml;
        return AsyncThreadService.submit(new Callable<SpeechSynthesisResult>(){

            @Override
            public SpeechSynthesisResult call() {
                final SpeechSynthesisResult[] result = new SpeechSynthesisResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef resultRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.speakSsml(SpeechSynthesizer.this.synthHandle, finalSsml, resultRef));
                        result[0] = new SpeechSynthesisResult(resultRef);
                    }
                };
                thisSynth.doAsyncSynthesisAction(runnable);
                return result[0];
            }
        });
    }

    public SpeechSynthesisResult StartSpeakingText(String text) {
        IntRef resultRef = new IntRef(0L);
        Contracts.throwIfFail(this.startSpeakingText(this.synthHandle, text, resultRef));
        return new SpeechSynthesisResult(resultRef);
    }

    public SpeechSynthesisResult StartSpeakingSsml(String ssml) {
        IntRef resultRef = new IntRef(0L);
        Contracts.throwIfFail(this.startSpeakingSsml(this.synthHandle, ssml, resultRef));
        return new SpeechSynthesisResult(resultRef);
    }

    public Future<SpeechSynthesisResult> StartSpeakingTextAsync(String text) {
        final SpeechSynthesizer thisSynth = this;
        final String finalText = text;
        return AsyncThreadService.submit(new Callable<SpeechSynthesisResult>(){

            @Override
            public SpeechSynthesisResult call() {
                final SpeechSynthesisResult[] result = new SpeechSynthesisResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef resultRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.startSpeakingText(SpeechSynthesizer.this.synthHandle, finalText, resultRef));
                        result[0] = new SpeechSynthesisResult(resultRef);
                    }
                };
                thisSynth.doAsyncSynthesisAction(runnable);
                return result[0];
            }
        });
    }

    public Future<SpeechSynthesisResult> StartSpeakingSsmlAsync(String ssml) {
        final SpeechSynthesizer thisSynth = this;
        final String finalSsml = ssml;
        return AsyncThreadService.submit(new Callable<SpeechSynthesisResult>(){

            @Override
            public SpeechSynthesisResult call() {
                final SpeechSynthesisResult[] result = new SpeechSynthesisResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef resultRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.startSpeakingSsml(SpeechSynthesizer.this.synthHandle, finalSsml, resultRef));
                        result[0] = new SpeechSynthesisResult(resultRef);
                    }
                };
                thisSynth.doAsyncSynthesisAction(runnable);
                return result[0];
            }
        });
    }

    public Future<Void> StopSpeakingAsync() {
        final SpeechSynthesizer thisSync = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SpeechSynthesizer.this.stopSpeaking(SpeechSynthesizer.this.synthHandle);
                    }
                };
                thisSync.doAsyncSynthesisAction(runnable);
                return null;
            }
        });
    }

    public Future<SynthesisVoicesResult> getVoicesAsync(String locale) {
        final SpeechSynthesizer thisSynth = this;
        final String finalLocale = locale;
        return AsyncThreadService.submit(new Callable<SynthesisVoicesResult>(){

            @Override
            public SynthesisVoicesResult call() {
                final SynthesisVoicesResult[] result = new SynthesisVoicesResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef resultRef = new IntRef(0L);
                        Contracts.throwIfFail(SpeechSynthesizer.this.getVoices(SpeechSynthesizer.this.synthHandle, finalLocale, resultRef));
                        result[0] = new SynthesisVoicesResult(resultRef);
                    }
                };
                thisSynth.doAsyncSynthesisAction(runnable);
                return result[0];
            }
        });
    }

    public Future<SynthesisVoicesResult> getVoicesAsync() {
        return this.getVoicesAsync("");
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public void setAuthorizationToken(String token) {
        Contracts.throwIfNullOrWhitespace(token, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, token);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.synthesizerLock;
        synchronized (object) {
            if (this.activeAsyncSynthesisCounter != 0) {
                try {
                    this.synthesizerLock.wait(disposeWaitingTime.intValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.activeAsyncSynthesisCounter != 0) {
                throw new IllegalStateException("Cannot dispose a synthesizer while async synthesis is running. Await async synthesis to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public SafeHandle getImpl() {
        return this.synthHandle;
    }

    private void initialize() {
        final SpeechSynthesizer _this = this;
        AsyncThreadService.initialize();
        this.SynthesisStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(_this);
                Contracts.throwIfFail(SpeechSynthesizer.this.synthesisStartedSetCallback(_this.synthHandle));
            }
        });
        this.Synthesizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(_this);
                Contracts.throwIfFail(SpeechSynthesizer.this.synthesizingSetCallback(_this.synthHandle));
            }
        });
        this.SynthesisCompleted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(_this);
                Contracts.throwIfFail(SpeechSynthesizer.this.synthesisCompletedSetCallback(_this.synthHandle));
            }
        });
        this.SynthesisCanceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(_this);
                Contracts.throwIfFail(SpeechSynthesizer.this.synthesisCanceledSetCallback(_this.synthHandle));
            }
        });
        this.WordBoundary.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(_this);
                Contracts.throwIfFail(SpeechSynthesizer.this.wordBoundarySetCallback(_this.synthHandle));
            }
        });
        this.VisemeReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(_this);
                Contracts.throwIfFail(SpeechSynthesizer.this.visemeReceivedSetCallback(_this.synthHandle));
            }
        });
        this.BookmarkReached.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                s_speechSynthesizerObjects.add(_this);
                Contracts.throwIfFail(SpeechSynthesizer.this.bookmarkReachedSetCallback(_this.synthHandle));
            }
        });
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromSynthesizerHandle(_this.synthHandle, propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncSynthesisAction(Runnable synthImplAction) {
        Object object = this.synthesizerLock;
        synchronized (object) {
            ++this.activeAsyncSynthesisCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            synthImplAction.run();
        }
        finally {
            object = this.synthesizerLock;
            synchronized (object) {
                --this.activeAsyncSynthesisCounter;
                this.synthesizerLock.notifyAll();
            }
        }
    }

    private void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.synthHandle != null) {
                this.synthHandle.close();
                this.synthHandle = null;
            }
            this.audioOutputKeepAlive = null;
            s_speechSynthesizerObjects.remove(this);
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    private void synthesisStartedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisEventArgs resultEventArg = new SpeechSynthesisEventArgs(eventArgs);
            EventHandlerImpl<SpeechSynthesisEventArgs> handler = this.SynthesisStarted;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesizingEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisEventArgs resultEventArg = new SpeechSynthesisEventArgs(eventArgs);
            EventHandlerImpl<SpeechSynthesisEventArgs> handler = this.Synthesizing;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesisCompletedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisEventArgs resultEventArg = new SpeechSynthesisEventArgs(eventArgs);
            EventHandlerImpl<SpeechSynthesisEventArgs> handler = this.SynthesisCompleted;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesisCanceledEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisEventArgs resultEventArg = new SpeechSynthesisEventArgs(eventArgs);
            EventHandlerImpl<SpeechSynthesisEventArgs> handler = this.SynthesisCanceled;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void wordBoundaryEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisWordBoundaryEventArgs resultEventArg = new SpeechSynthesisWordBoundaryEventArgs(eventArgs);
            EventHandlerImpl<SpeechSynthesisWordBoundaryEventArgs> handler = this.WordBoundary;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void visemeReceivedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisVisemeEventArgs resultEventArg = new SpeechSynthesisVisemeEventArgs(eventArgs);
            EventHandlerImpl<SpeechSynthesisVisemeEventArgs> handler = this.VisemeReceived;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bookmarkReachedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "synthesizer");
            if (this.disposed) {
                return;
            }
            SpeechSynthesisBookmarkEventArgs resultEventArg = new SpeechSynthesisBookmarkEventArgs(eventArgs);
            EventHandlerImpl<SpeechSynthesisBookmarkEventArgs> handler = this.BookmarkReached;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createSpeechSynthesizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long createSpeechSynthesizerFromAutoDetectSourceLangConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3, SafeHandle var4);

    private final native long speakText(SafeHandle var1, String var2, IntRef var3);

    private final native long speakSsml(SafeHandle var1, String var2, IntRef var3);

    private final native long startSpeakingText(SafeHandle var1, String var2, IntRef var3);

    private final native long startSpeakingSsml(SafeHandle var1, String var2, IntRef var3);

    private final native long stopSpeaking(SafeHandle var1);

    private final native long getVoices(SafeHandle var1, String var2, IntRef var3);

    private final native long synthesisStartedSetCallback(SafeHandle var1);

    private final native long synthesizingSetCallback(SafeHandle var1);

    private final native long synthesisCompletedSetCallback(SafeHandle var1);

    private final native long synthesisCanceledSetCallback(SafeHandle var1);

    private final native long wordBoundarySetCallback(SafeHandle var1);

    private final native long visemeReceivedSetCallback(SafeHandle var1);

    private final native long bookmarkReachedSetCallback(SafeHandle var1);

    private final native long getPropertyBagFromSynthesizerHandle(SafeHandle var1, IntRef var2);
}

