/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SynthesisVoiceGender;
import com.microsoft.cognitiveservices.speech.SynthesisVoiceType;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VoiceInfo
implements AutoCloseable {
    private String name;
    private String locale;
    private String shortName;
    private String localName;
    private SynthesisVoiceGender gender;
    private SynthesisVoiceType voiceType;
    private List<String> styleList;
    private String voicePath;
    private PropertyCollection properties;
    private SafeHandle voiceInfoHandle = null;

    protected VoiceInfo(IntRef result) {
        Contracts.throwIfNull(result, "result");
        this.voiceInfoHandle = new SafeHandle(result.getValue(), SafeHandleType.VoiceInfo);
        this.name = this.getName(this.voiceInfoHandle);
        this.locale = this.getLocale(this.voiceInfoHandle);
        this.shortName = this.getShortName(this.voiceInfoHandle);
        this.localName = this.getLocalName(this.voiceInfoHandle);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getVoiceType(this.voiceInfoHandle, intRef));
        this.voiceType = SynthesisVoiceType.values()[(int)intRef.getValue() - 1];
        String styleListString = this.getStyleListString(this.voiceInfoHandle);
        this.styleList = styleListString.isEmpty() ? new ArrayList<String>() : Arrays.asList(styleListString.split("\\|"));
        this.voicePath = this.getVoicePath(this.voiceInfoHandle);
        IntRef propertyRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromResult(this.voiceInfoHandle, propertyRef));
        this.properties = new PropertyCollection(propertyRef);
        String genderStr = this.properties.getProperty("Gender");
        this.gender = genderStr.equals("Female") ? SynthesisVoiceGender.Female : (genderStr.equals("Male") ? SynthesisVoiceGender.Male : SynthesisVoiceGender.Unknown);
    }

    public String getName() {
        return this.name;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public SynthesisVoiceGender getGender() {
        return this.gender;
    }

    public SynthesisVoiceType getVoiceType() {
        return this.voiceType;
    }

    public List<String> getStyleList() {
        return this.styleList;
    }

    public String getVoicePath() {
        return this.voicePath;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        if (this.voiceInfoHandle != null) {
            this.voiceInfoHandle.close();
            this.voiceInfoHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
    }

    public SafeHandle getImpl() {
        return this.voiceInfoHandle;
    }

    private final native String getName(SafeHandle var1);

    private final native String getLocale(SafeHandle var1);

    private final native String getShortName(SafeHandle var1);

    private final native String getLocalName(SafeHandle var1);

    private final native String getStyleListString(SafeHandle var1);

    private final native String getVoicePath(SafeHandle var1);

    private final native long getVoiceType(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);
}

