/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamFormat;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStreamCallback;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class PullAudioInputStream
extends AudioInputStream {
    private PullAudioInputStreamCallback callbackHandle;

    public static PullAudioInputStream create(PullAudioInputStreamCallback callback) {
        SafeHandle audioStreamHandle = new SafeHandle(0L, SafeHandleType.AudioInputStream);
        Contracts.throwIfFail(PullAudioInputStream.createPullAudioInputStream(audioStreamHandle, null));
        return new PullAudioInputStream(audioStreamHandle, callback);
    }

    public static PullAudioInputStream create(PullAudioInputStreamCallback callback, AudioStreamFormat format) {
        SafeHandle audioStreamHandle = new SafeHandle(0L, SafeHandleType.AudioInputStream);
        Contracts.throwIfFail(PullAudioInputStream.createPullAudioInputStream(audioStreamHandle, format.getImpl()));
        return new PullAudioInputStream(audioStreamHandle, callback);
    }

    @Override
    public void close() {
        this.callbackHandle = null;
        super.close();
    }

    PullAudioInputStream(SafeHandle stream, PullAudioInputStreamCallback callback) {
        super(stream);
        Contracts.throwIfNull(this.getImpl(), "streamHandle");
        this.callbackHandle = callback;
        Contracts.throwIfFail(this.setStreamCallbacks(this.getImpl()));
    }

    private PullAudioInputStreamCallback getCallbackHandle() {
        return this.callbackHandle;
    }

    private static final native long createPullAudioInputStream(SafeHandle var0, SafeHandle var1);

    private final native long setStreamCallbacks(SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

