/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioOutputStream;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public final class PullAudioOutputStream
extends AudioOutputStream {
    public static PullAudioOutputStream create() {
        IntRef audioStreamHandle = new IntRef(0L);
        Contracts.throwIfFail(PullAudioOutputStream.createPullAudioOutputStream(audioStreamHandle));
        return new PullAudioOutputStream(audioStreamHandle);
    }

    public long read(byte[] dataBuffer) {
        IntRef filledSize = new IntRef(0L);
        Contracts.throwIfFail(this.pullAudioOutputStreamRead(this.getImpl(), dataBuffer, filledSize));
        return filledSize.getValue();
    }

    public PullAudioOutputStream(IntRef stream) {
        super(stream);
    }

    private static final native long createPullAudioOutputStream(IntRef var0);

    private final native long pullAudioOutputStreamRead(SafeHandle var1, byte[] var2, IntRef var3);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

