/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.dialog;

import com.microsoft.cognitiveservices.speech.dialog.DialogServiceConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;

public final class BotFrameworkConfig
extends DialogServiceConfig {
    private BotFrameworkConfig(long handleValue) {
        super(handleValue);
    }

    public static BotFrameworkConfig fromSubscription(String subscription, String region) {
        Contracts.throwIfNull(subscription, "subscription");
        Contracts.throwIfNull(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(BotFrameworkConfig.fromSubscription(configRef, subscription, region, null));
        return new BotFrameworkConfig(configRef.getValue());
    }

    public static BotFrameworkConfig fromSubscription(String subscription, String region, String botId) {
        Contracts.throwIfNull(subscription, "subscription");
        Contracts.throwIfNull(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(BotFrameworkConfig.fromSubscription(configRef, subscription, region, botId));
        return new BotFrameworkConfig(configRef.getValue());
    }

    public static BotFrameworkConfig fromAuthorizationToken(String authorizationToken, String region) {
        Contracts.throwIfNullOrWhitespace(authorizationToken, "authorizationToken");
        Contracts.throwIfNullOrWhitespace(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(BotFrameworkConfig.fromAuthorizationToken(configRef, authorizationToken, region, null));
        return new BotFrameworkConfig(configRef.getValue());
    }

    public static BotFrameworkConfig fromAuthorizationToken(String authorizationToken, String region, String botId) {
        Contracts.throwIfNullOrWhitespace(authorizationToken, "authorizationToken");
        Contracts.throwIfNullOrWhitespace(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(BotFrameworkConfig.fromAuthorizationToken(configRef, authorizationToken, region, botId));
        return new BotFrameworkConfig(configRef.getValue());
    }

    private static final native long fromSubscription(IntRef var0, String var1, String var2, String var3);

    private static final native long fromAuthorizationToken(IntRef var0, String var1, String var2, String var3);
}

