/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.dialog;

import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.dialog.DialogServiceConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;

public final class CustomCommandsConfig
extends DialogServiceConfig {
    private CustomCommandsConfig(long handleValue) {
        super(handleValue);
    }

    public static CustomCommandsConfig fromSubscription(String appId, String subscription, String region) {
        Contracts.throwIfNull(appId, "appId");
        Contracts.throwIfNull(subscription, "subscription");
        Contracts.throwIfNull(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(CustomCommandsConfig.fromSubscription(configRef, appId, subscription, region));
        return new CustomCommandsConfig(configRef.getValue());
    }

    public static CustomCommandsConfig fromAuthorizationToken(String appId, String authorizationToken, String region) {
        Contracts.throwIfNull(appId, "appId");
        Contracts.throwIfNullOrWhitespace(authorizationToken, "authorizationToken");
        Contracts.throwIfNullOrWhitespace(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(CustomCommandsConfig.fromAuthorizationToken(configRef, appId, authorizationToken, region));
        return new CustomCommandsConfig(configRef.getValue());
    }

    public void setApplicationId(String value) {
        this.setProperty(PropertyId.Conversation_ApplicationId, value);
    }

    public String getApplicationId() {
        return this.getProperty(PropertyId.Conversation_ApplicationId);
    }

    private static final native long fromSubscription(IntRef var0, String var1, String var2, String var3);

    private static final native long fromAuthorizationToken(IntRef var0, String var1, String var2, String var3);
}

