/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.KeyedItem;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class LanguageUnderstandingModel
implements KeyedItem {
    protected String modelId;
    private SafeHandle modelHandle = null;

    public void setId(String modelId) {
        this.modelId = modelId;
    }

    @Override
    public String getId() {
        return this.modelId;
    }

    public static LanguageUnderstandingModel fromEndpoint(String uri) {
        Contracts.throwIfNullOrWhitespace(uri, "uri");
        IntRef luModel = new IntRef(0L);
        Contracts.throwIfFail(LanguageUnderstandingModel.createModelFromUri(luModel, uri));
        return new LanguageUnderstandingModel(luModel);
    }

    public static LanguageUnderstandingModel fromAppId(String appId) {
        Contracts.throwIfNullOrWhitespace(appId, "appId");
        IntRef luModel = new IntRef(0L);
        Contracts.throwIfFail(LanguageUnderstandingModel.createModelFromAppId(luModel, appId));
        return new LanguageUnderstandingModel(luModel);
    }

    public static LanguageUnderstandingModel fromSubscription(String subscriptionKey, String appId, String region) {
        Contracts.throwIfNullOrWhitespace(subscriptionKey, "subscriptionKey");
        Contracts.throwIfNullOrWhitespace(appId, "appId");
        Contracts.throwIfNullOrWhitespace(region, "region");
        IntRef luModel = new IntRef(0L);
        Contracts.throwIfFail(LanguageUnderstandingModel.createModelFromSubscription(luModel, subscriptionKey, appId, region));
        return new LanguageUnderstandingModel(luModel);
    }

    LanguageUnderstandingModel(IntRef model) {
        Contracts.throwIfNull(model, "model");
        this.modelHandle = new SafeHandle(model.getValue(), SafeHandleType.LanguageUnderstandingModel);
        this.modelId = LanguageUnderstandingModel.languageUnderstandingModelGetModelId(this.modelHandle);
    }

    protected LanguageUnderstandingModel() {
    }

    public SafeHandle getImpl() {
        return this.modelHandle;
    }

    private static final native long createModelFromUri(IntRef var0, String var1);

    private static final native long createModelFromAppId(IntRef var0, String var1);

    private static final native long createModelFromSubscription(IntRef var0, String var1, String var2, String var3);

    private static final native String languageUnderstandingModelGetModelId(SafeHandle var0);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

