/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.Participant;
import com.microsoft.cognitiveservices.speech.transcription.ParticipantChangedReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.util.ArrayList;
import java.util.List;

public class ConversationParticipantsChangedEventArgs
extends SessionEventArgs {
    private List<Participant> participants;
    private ParticipantChangedReason reason;

    ConversationParticipantsChangedEventArgs(long eventArgs) {
        super(eventArgs);
        this.storeEventData(eventArgs, false);
    }

    ConversationParticipantsChangedEventArgs(long eventArgs, boolean dispose) {
        super(eventArgs);
        this.storeEventData(eventArgs, dispose);
    }

    public ParticipantChangedReason getReason() {
        return this.reason;
    }

    public List<Participant> getParticipants() {
        return this.participants;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.getSessionId() + " Reason:" + (Object)((Object)this.reason) + " Participants:" + this.participants.size();
    }

    private void storeEventData(long eventArgs, boolean disposeNativeResources) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef intVal = new IntRef(0L);
        Contracts.throwIfFail(this.getReason(this.eventHandle, intVal));
        this.reason = ParticipantChangedReason.values()[(int)intVal.getValue()];
        this.participants = new ArrayList<Participant>();
        IntRef resultRef = new IntRef(0L);
        int index = 0;
        long result = this.getParticipantAt(this.eventHandle, index, resultRef);
        while (resultRef.getValue() > 0L) {
            Participant participant = new Participant(resultRef.getValue());
            this.participants.add(participant);
            resultRef = new IntRef(0L);
            result = this.getParticipantAt(this.eventHandle, ++index, resultRef);
        }
        if (disposeNativeResources) {
            super.close();
        }
    }

    private final native long getParticipantAt(SafeHandle var1, int var2, IntRef var3);

    private final native long getReason(SafeHandle var1, IntRef var2);
}

