/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.transcription.Meeting;
import com.microsoft.cognitiveservices.speech.transcription.MeetingTranscriptionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.MeetingTranscriptionEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class MeetingTranscriber
extends Recognizer {
    public final EventHandlerImpl<MeetingTranscriptionEventArgs> transcribing;
    public final EventHandlerImpl<MeetingTranscriptionEventArgs> transcribed;
    public final EventHandlerImpl<MeetingTranscriptionCanceledEventArgs> canceled;
    static Set<MeetingTranscriber> meetingTranscriberObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;

    public MeetingTranscriber() {
        super(null);
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createMeetingTranscriberFromConfig(super.getImpl(), null));
        this.initialize();
    }

    public MeetingTranscriber(AudioConfig audioConfig) {
        super(audioConfig);
        this.transcribing = new EventHandlerImpl(this.eventCounter);
        this.transcribed = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createMeetingTranscriberFromConfig(super.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createMeetingTranscriberFromConfig(super.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public OutputFormat getOutputFormat() {
        if (this.propertyHandle.getProperty(PropertyId.SpeechServiceResponse_RequestDetailedResultTrueFalse).equals("true")) {
            return OutputFormat.Detailed;
        }
        return OutputFormat.Simple;
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Void> joinMeetingAsync(Meeting meeting) {
        final MeetingTranscriber thisReco = this;
        final Meeting thisMeeting = meeting;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.joinMeeting(MeetingTranscriber.this.getImpl(), thisMeeting.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> leaveMeetingAsync() {
        final MeetingTranscriber thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.leaveMeeting(MeetingTranscriber.this.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startTranscribingAsync() {
        final MeetingTranscriber thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.startContinuousRecognition(MeetingTranscriber.this.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopTranscribingAsync() {
        final MeetingTranscriber thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.stopContinuousRecognition(MeetingTranscriber.this.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    @Override
    protected void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            meetingTranscriberObjects.remove(this);
            super.dispose(disposing);
        }
    }

    private void initialize() {
        final MeetingTranscriber _this = this;
        this.transcribing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(_this);
                Contracts.throwIfFail(MeetingTranscriber.this.recognizingSetCallback(_this.getImpl().getValue()));
            }
        });
        this.transcribed.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(_this);
                Contracts.throwIfFail(MeetingTranscriber.this.recognizedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(_this);
                Contracts.throwIfFail(MeetingTranscriber.this.canceledSetCallback(_this.getImpl().getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(_this);
                Contracts.throwIfFail(MeetingTranscriber.this.sessionStartedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(_this);
                Contracts.throwIfFail(MeetingTranscriber.this.sessionStoppedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(_this);
                Contracts.throwIfFail(MeetingTranscriber.this.speechStartDetectedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                meetingTranscriberObjects.add(_this);
                Contracts.throwIfFail(MeetingTranscriber.this.speechEndDetectedSetCallback(_this.getImpl().getValue()));
            }
        });
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(_this.getImpl(), propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    private void recognizingEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            MeetingTranscriptionEventArgs resultEventArg = new MeetingTranscriptionEventArgs(eventArgs, true);
            EventHandlerImpl<MeetingTranscriptionEventArgs> handler = this.transcribing;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            MeetingTranscriptionEventArgs resultEventArg = new MeetingTranscriptionEventArgs(eventArgs, true);
            EventHandlerImpl<MeetingTranscriptionEventArgs> handler = this.transcribed;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            MeetingTranscriptionCanceledEventArgs resultEventArg = new MeetingTranscriptionCanceledEventArgs(eventArgs, true);
            EventHandlerImpl<MeetingTranscriptionCanceledEventArgs> handler = this.canceled;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createMeetingTranscriberFromConfig(SafeHandle var1, SafeHandle var2);

    private final native long joinMeeting(SafeHandle var1, SafeHandle var2);

    private final native long leaveMeeting(SafeHandle var1);
}

