/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.MeetingTranscriptionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;

public class MeetingTranscriptionEventArgs
extends RecognitionEventArgs {
    private MeetingTranscriptionResult result;

    MeetingTranscriptionEventArgs(long eventArgs) {
        super(eventArgs);
        this.storeEventData(false);
    }

    MeetingTranscriptionEventArgs(long eventArgs, boolean dispose) {
        super(eventArgs);
        this.storeEventData(dispose);
    }

    public final MeetingTranscriptionResult getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.getSessionId() + " ResultId:" + this.result.getResultId() + " Reason:" + (Object)((Object)this.result.getReason()) + " UserId:" + this.result.getUserId() + " UtteranceId:" + this.result.getUtteranceId() + " Recognized text:<" + this.result.getText() + ">.";
    }

    private void storeEventData(boolean disposeNativeResources) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef resultHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getRecognitionResult(this.eventHandle, resultHandle));
        this.result = new MeetingTranscriptionResult(resultHandle.getValue());
        Contracts.throwIfNull(this.getSessionId(), "SessionId");
        if (disposeNativeResources) {
            super.close();
        }
    }
}

