/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.HybridSpeechConfig;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.translation.SpeechTranslationConfig;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionResult;
import com.microsoft.cognitiveservices.speech.translation.TranslationSynthesisEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class TranslationRecognizer
extends Recognizer {
    public final EventHandlerImpl<TranslationRecognitionEventArgs> recognizing;
    public final EventHandlerImpl<TranslationRecognitionEventArgs> recognized;
    public final EventHandlerImpl<TranslationRecognitionCanceledEventArgs> canceled;
    public final EventHandlerImpl<TranslationSynthesisEventArgs> synthesizing;
    static Set<TranslationRecognizer> translationRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;
    SafeHandle translationSynthesisHandle;

    public TranslationRecognizer(SpeechTranslationConfig stc) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(stc, "stc");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), stc.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(HybridSpeechConfig hybridSpeechConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(hybridSpeechConfig, "hybridSpeechConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), hybridSpeechConfig.getImpl(), null));
        this.initialize();
    }

    public TranslationRecognizer(SpeechTranslationConfig stc, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(stc, "stc");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), stc.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), stc.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public TranslationRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public TranslationRecognizer(HybridSpeechConfig hybridSpeechConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.synthesizing = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        this.translationSynthesisHandle = null;
        Contracts.throwIfNull(hybridSpeechConfig, "hybridSpeechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), hybridSpeechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createTranslationRecognizerFromConfig(super.getImpl(), hybridSpeechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public void addTargetLanguage(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        Contracts.throwIfFail(this.addTargetLanguage(super.getImpl(), value));
    }

    public void removeTargetLanguage(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        Contracts.throwIfFail(this.removeTargetLanguage(super.getImpl(), value));
    }

    public ArrayList<String> getTargetLanguages() {
        ArrayList<String> result = new ArrayList<String>();
        String plainStr = this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_TranslationToLanguages);
        String[] values = plainStr.split(",");
        for (int i = 0; i < values.length; ++i) {
            result.add(values[i]);
        }
        return result;
    }

    public String getVoiceName() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_TranslationVoice);
    }

    public void setAuthorizationToken(String token) {
        Contracts.throwIfNullOrWhitespace(token, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, token);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<TranslationRecognitionResult> recognizeOnceAsync() {
        final TranslationRecognizer thisReco = this;
        return AsyncThreadService.submit(new Callable<TranslationRecognitionResult>(){

            @Override
            public TranslationRecognitionResult call() {
                final TranslationRecognitionResult[] result = new TranslationRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        result[0] = new TranslationRecognitionResult(thisReco.recognize());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return result[0];
            }
        });
    }

    public Future<Void> startContinuousRecognitionAsync() {
        final TranslationRecognizer thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.startContinuousRecognition(TranslationRecognizer.this.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopContinuousRecognitionAsync() {
        final TranslationRecognizer thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.stopContinuousRecognition(TranslationRecognizer.this.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    @Override
    protected void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.translationSynthesisHandle != null) {
                this.translationSynthesisHandle.close();
                this.translationSynthesisHandle = null;
            }
            translationRecognizerObjects.remove(this);
            super.dispose(disposing);
        }
    }

    private void initialize() {
        final TranslationRecognizer _this = this;
        this.translationSynthesisHandle = new SafeHandle(_this.getImpl().getValue(), SafeHandleType.TranslationSynthesis);
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(_this);
                Contracts.throwIfFail(TranslationRecognizer.this.recognizingSetCallback(_this.getImpl().getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(_this);
                Contracts.throwIfFail(TranslationRecognizer.this.recognizedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.synthesizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(_this);
                Contracts.throwIfFail(TranslationRecognizer.this.synthesizingSetCallback(_this.getImpl().getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(_this);
                Contracts.throwIfFail(TranslationRecognizer.this.canceledSetCallback(_this.getImpl().getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(_this);
                Contracts.throwIfFail(TranslationRecognizer.this.sessionStartedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(_this);
                Contracts.throwIfFail(TranslationRecognizer.this.sessionStoppedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(_this);
                Contracts.throwIfFail(TranslationRecognizer.this.speechStartDetectedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                translationRecognizerObjects.add(_this);
                Contracts.throwIfFail(TranslationRecognizer.this.speechEndDetectedSetCallback(_this.getImpl().getValue()));
            }
        });
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(_this.getImpl(), propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    private void recognizingEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionEventArgs resultEventArg = new TranslationRecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<TranslationRecognitionEventArgs> handler = this.recognizing;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionEventArgs resultEventArg = new TranslationRecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<TranslationRecognitionEventArgs> handler = this.recognized;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationRecognitionCanceledEventArgs resultEventArg = new TranslationRecognitionCanceledEventArgs(eventArgs, true);
            EventHandlerImpl<TranslationRecognitionCanceledEventArgs> handler = this.canceled;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void synthesizingEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            TranslationSynthesisEventArgs resultEventArg = new TranslationSynthesisEventArgs(eventArgs, true);
            EventHandlerImpl<TranslationSynthesisEventArgs> handler = this.synthesizing;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final native long createTranslationRecognizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long synthesizingSetCallback(long var1);

    private final native long addTargetLanguage(SafeHandle var1, String var2);

    private final native long removeTargetLanguage(SafeHandle var1, String var2);
}

