/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationSynthesisResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public final class TranslationSynthesisEventArgs
extends SessionEventArgs {
    private TranslationSynthesisResult result;

    TranslationSynthesisEventArgs(long eventArgs) {
        super(eventArgs);
        this.storeEventData(false);
    }

    TranslationSynthesisEventArgs(long eventArgs, boolean dispose) {
        super(eventArgs);
        this.storeEventData(dispose);
    }

    public final TranslationSynthesisResult getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        return "SessionId:" + this.getSessionId() + " Result:" + this.result.toString() + ".";
    }

    private void storeEventData(boolean disposeNativeResources) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef resultHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getSynthesisResult(this.eventHandle, resultHandle));
        this.result = new TranslationSynthesisResult(resultHandle.getValue());
        Contracts.throwIfNull(this.getSessionId(), "SessionId");
        if (disposeNativeResources) {
            super.close();
        }
    }

    private final native long getSynthesisResult(SafeHandle var1, IntRef var2);
}

