/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CloseGuard {
    private AtomicBoolean isClosed = new AtomicBoolean();
    private AtomicInteger inUseCount = new AtomicInteger();

    public CloseGuard() {
        this.isClosed.set(false);
        this.inUseCount.set(0);
    }

    public void closeObject() {
        this.isClosed.set(true);
        int closeAttempts = 0;
        while (!this.inUseCount.compareAndSet(0, -1)) {
            if (this.inUseCount.get() == -1) {
                return;
            }
            if (closeAttempts++ != 100) continue;
            closeAttempts = 0;
            Thread.yield();
        }
    }

    public void enterUseObject() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("Attempt to use closed object rejected.");
        }
        int currentVal = 0;
        int attempts = 0;
        while (!this.inUseCount.compareAndSet(currentVal, currentVal + 1)) {
            if (attempts++ == 100) {
                attempts = 0;
                Thread.yield();
            }
            if ((currentVal = this.inUseCount.get()) != -1) continue;
            throw new IllegalStateException("Attempt to use closed object rejected.");
        }
    }

    public void exitUseObject() {
        this.inUseCount.decrementAndGet();
    }
}

