/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.EventHandler;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class EventHandlerImpl<T> {
    private ArrayList<EventHandler<T>> eventHandlerClients = new ArrayList();
    private Runnable notifyConnectedOnce;
    private boolean notifyConnectedOnceFired = false;
    private AtomicInteger runCounter;

    public EventHandlerImpl(AtomicInteger runCounter) {
        this.runCounter = runCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNotificationOnConnected(Runnable notifyConnectedOnce) {
        EventHandlerImpl eventHandlerImpl = this;
        synchronized (eventHandlerImpl) {
            if (this.notifyConnectedOnceFired) {
                notifyConnectedOnce.run();
            }
            this.notifyConnectedOnce = notifyConnectedOnce;
        }
    }

    public boolean isUpdateNotificationOnConnectedFired() {
        return this.notifyConnectedOnceFired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventHandler<T> handler) {
        EventHandlerImpl eventHandlerImpl = this;
        synchronized (eventHandlerImpl) {
            if (!this.notifyConnectedOnceFired) {
                this.notifyConnectedOnceFired = true;
                if (this.notifyConnectedOnce != null) {
                    this.notifyConnectedOnce.run();
                }
            }
        }
        this.eventHandlerClients.add(handler);
    }

    public void removeEventListener(EventHandler<T> handler) {
        this.eventHandlerClients.remove(handler);
    }

    public void fireEvent(Object sender, T e) {
        for (EventHandler<T> a : this.eventHandlerClients) {
            if (null != this.runCounter) {
                this.runCounter.incrementAndGet();
            }
            a.onEvent(sender, e);
            if (null == this.runCounter) continue;
            this.runCounter.decrementAndGet();
        }
    }
}

