/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DirectoryObjectGetMemberObjectsBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetMemberObjectsCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetMemberObjectsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectGetMemberObjectsCollectionResponse;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetMemberObjectsCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryObjectGetMemberObjectsCollectionRequest;
import java.util.List;

public class DirectoryObjectGetMemberObjectsCollectionRequest
extends BaseCollectionRequest<DirectoryObjectGetMemberObjectsCollectionResponse, IDirectoryObjectGetMemberObjectsCollectionPage>
implements IDirectoryObjectGetMemberObjectsCollectionRequest {
    protected final DirectoryObjectGetMemberObjectsBody body = new DirectoryObjectGetMemberObjectsBody();

    public DirectoryObjectGetMemberObjectsCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectGetMemberObjectsCollectionResponse.class, IDirectoryObjectGetMemberObjectsCollectionPage.class);
    }

    @Override
    public void post(final ICallback<IDirectoryObjectGetMemberObjectsCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DirectoryObjectGetMemberObjectsCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryObjectGetMemberObjectsCollectionPage post() throws ClientException {
        DirectoryObjectGetMemberObjectsCollectionResponse response = (DirectoryObjectGetMemberObjectsCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IDirectoryObjectGetMemberObjectsCollectionPage buildFromResponse(DirectoryObjectGetMemberObjectsCollectionResponse response) {
        DirectoryObjectGetMemberObjectsCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryObjectGetMemberObjectsCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DirectoryObjectGetMemberObjectsCollectionPage page = new DirectoryObjectGetMemberObjectsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDirectoryObjectGetMemberObjectsCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryObjectGetMemberObjectsCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDirectoryObjectGetMemberObjectsCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

