/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.IdentityProvider;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IIdentityProviderRequest;
import java.util.List;

public class IdentityProviderRequest
extends BaseRequest
implements IIdentityProviderRequest {
    public IdentityProviderRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProvider.class);
    }

    @Override
    public void get(ICallback<IdentityProvider> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public IdentityProvider get() throws ClientException {
        return (IdentityProvider)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<IdentityProvider> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(IdentityProvider sourceIdentityProvider, ICallback<IdentityProvider> callback) {
        this.send(HttpMethod.PATCH, callback, sourceIdentityProvider);
    }

    @Override
    public IdentityProvider patch(IdentityProvider sourceIdentityProvider) throws ClientException {
        return (IdentityProvider)this.send(HttpMethod.PATCH, sourceIdentityProvider);
    }

    @Override
    public void post(IdentityProvider newIdentityProvider, ICallback<IdentityProvider> callback) {
        this.send(HttpMethod.POST, callback, newIdentityProvider);
    }

    @Override
    public IdentityProvider post(IdentityProvider newIdentityProvider) throws ClientException {
        return (IdentityProvider)this.send(HttpMethod.POST, newIdentityProvider);
    }

    @Override
    public IIdentityProviderRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IIdentityProviderRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

