// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Alert Collection Request.
 */
public class AlertCollectionRequest extends BaseCollectionRequest<AlertCollectionResponse, IAlertCollectionPage> implements IAlertCollectionRequest {

    /**
     * The request builder for this collection of Alert
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AlertCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AlertCollectionResponse.class, IAlertCollectionPage.class);
    }

    public void get(final ICallback<IAlertCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IAlertCollectionPage get() throws ClientException {
        final AlertCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Alert newAlert, final ICallback<Alert> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new AlertRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newAlert, callback);
    }

    public Alert post(final Alert newAlert) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new AlertRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newAlert);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IAlertCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (AlertCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IAlertCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (AlertCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IAlertCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (AlertCollectionRequest)this;
    }

    public IAlertCollectionPage buildFromResponse(final AlertCollectionResponse response) {
        final IAlertCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new AlertCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final AlertCollectionPage page = new AlertCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
