// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Collection Request.
 */
public class DriveCollectionRequest extends BaseCollectionRequest<DriveCollectionResponse, IDriveCollectionPage> implements IDriveCollectionRequest {

    /**
     * The request builder for this collection of Drive
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DriveCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveCollectionResponse.class, IDriveCollectionPage.class);
    }

    public void get(final ICallback<IDriveCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IDriveCollectionPage get() throws ClientException {
        final DriveCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Drive newDrive, final ICallback<Drive> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new DriveRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newDrive, callback);
    }

    public Drive post(final Drive newDrive) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new DriveRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newDrive);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IDriveCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (DriveCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IDriveCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (DriveCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IDriveCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (DriveCollectionRequest)this;
    }

    public IDriveCollectionPage buildFromResponse(final DriveCollectionResponse response) {
        final IDriveCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new DriveCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final DriveCollectionPage page = new DriveCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
