// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IEventDismissReminderRequest;
import com.microsoft.graph.requests.extensions.EventDismissReminderRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Event Dismiss Reminder Request Builder.
 */
public class EventDismissReminderRequestBuilder extends BaseActionRequestBuilder implements IEventDismissReminderRequestBuilder {

    /**
     * The request builder for this EventDismissReminder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EventDismissReminderRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IEventDismissReminderRequest
     *
     * @return the IEventDismissReminderRequest instance
     */
    public IEventDismissReminderRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IEventDismissReminderRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IEventDismissReminderRequest instance
     */
    public IEventDismissReminderRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        EventDismissReminderRequest request = new EventDismissReminderRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
