// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IFieldValueSetRequest;
import com.microsoft.graph.requests.extensions.FieldValueSetRequest;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Field Value Set Request Builder.
 */
public class FieldValueSetRequestBuilder extends BaseRequestBuilder implements IFieldValueSetRequestBuilder {

    /**
     * The request builder for the FieldValueSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public FieldValueSetRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IFieldValueSetRequest instance
     */
    public IFieldValueSetRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IFieldValueSetRequest instance
     */
    public IFieldValueSetRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new FieldValueSetRequest(getRequestUrl(), getClient(), requestOptions);
    }


}

