// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Entity With Reference Request.
 */
public interface IEntityWithReferenceRequest extends IHttpRequest {

    void post(final Entity newEntity, final IJsonBackedObject payload, final ICallback<Entity> callback);

    Entity post(final Entity newEntity, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<Entity> callback);

    Entity get() throws ClientException;

	void delete(final ICallback<Entity> callback);

	void delete() throws ClientException;

	void patch(final Entity sourceEntity, final ICallback<Entity> callback);

	Entity patch(final Entity sourceEntity) throws ClientException;

    IEntityWithReferenceRequest select(final String value);

    IEntityWithReferenceRequest expand(final String value);

}
