// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ManagedAppStatusRaw;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed App Status Raw Request.
 */
public interface IManagedAppStatusRawRequest extends IHttpRequest {

    /**
     * Gets the ManagedAppStatusRaw from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ManagedAppStatusRaw> callback);

    /**
     * Gets the ManagedAppStatusRaw from the service
     *
     * @return the ManagedAppStatusRaw from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAppStatusRaw get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ManagedAppStatusRaw> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ManagedAppStatusRaw with a source
     *
     * @param sourceManagedAppStatusRaw the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ManagedAppStatusRaw sourceManagedAppStatusRaw, final ICallback<ManagedAppStatusRaw> callback);

    /**
     * Patches this ManagedAppStatusRaw with a source
     *
     * @param sourceManagedAppStatusRaw the source object with updates
     * @return the updated ManagedAppStatusRaw
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAppStatusRaw patch(final ManagedAppStatusRaw sourceManagedAppStatusRaw) throws ClientException;

    /**
     * Posts a ManagedAppStatusRaw with a new object
     *
     * @param newManagedAppStatusRaw the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ManagedAppStatusRaw newManagedAppStatusRaw, final ICallback<ManagedAppStatusRaw> callback);

    /**
     * Posts a ManagedAppStatusRaw with a new object
     *
     * @param newManagedAppStatusRaw the new object to create
     * @return the created ManagedAppStatusRaw
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedAppStatusRaw post(final ManagedAppStatusRaw newManagedAppStatusRaw) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedAppStatusRawRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedAppStatusRawRequest expand(final String value);

}

