// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed Device With Reference Request.
 */
public interface IManagedDeviceWithReferenceRequest extends IHttpRequest {

    void post(final ManagedDevice newManagedDevice, final IJsonBackedObject payload, final ICallback<ManagedDevice> callback);

    ManagedDevice post(final ManagedDevice newManagedDevice, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<ManagedDevice> callback);

    ManagedDevice get() throws ClientException;

	void delete(final ICallback<ManagedDevice> callback);

	void delete() throws ClientException;

	void patch(final ManagedDevice sourceManagedDevice, final ICallback<ManagedDevice> callback);

	ManagedDevice patch(final ManagedDevice sourceManagedDevice) throws ClientException;

    IManagedDeviceWithReferenceRequest select(final String value);

    IManagedDeviceWithReferenceRequest expand(final String value);

}
