// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.MicrosoftStoreForBusinessApp;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Microsoft Store For Business App Request.
 */
public interface IMicrosoftStoreForBusinessAppRequest extends IHttpRequest {

    /**
     * Gets the MicrosoftStoreForBusinessApp from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<MicrosoftStoreForBusinessApp> callback);

    /**
     * Gets the MicrosoftStoreForBusinessApp from the service
     *
     * @return the MicrosoftStoreForBusinessApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftStoreForBusinessApp get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<MicrosoftStoreForBusinessApp> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MicrosoftStoreForBusinessApp with a source
     *
     * @param sourceMicrosoftStoreForBusinessApp the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final MicrosoftStoreForBusinessApp sourceMicrosoftStoreForBusinessApp, final ICallback<MicrosoftStoreForBusinessApp> callback);

    /**
     * Patches this MicrosoftStoreForBusinessApp with a source
     *
     * @param sourceMicrosoftStoreForBusinessApp the source object with updates
     * @return the updated MicrosoftStoreForBusinessApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftStoreForBusinessApp patch(final MicrosoftStoreForBusinessApp sourceMicrosoftStoreForBusinessApp) throws ClientException;

    /**
     * Posts a MicrosoftStoreForBusinessApp with a new object
     *
     * @param newMicrosoftStoreForBusinessApp the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final MicrosoftStoreForBusinessApp newMicrosoftStoreForBusinessApp, final ICallback<MicrosoftStoreForBusinessApp> callback);

    /**
     * Posts a MicrosoftStoreForBusinessApp with a new object
     *
     * @param newMicrosoftStoreForBusinessApp the new object to create
     * @return the created MicrosoftStoreForBusinessApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftStoreForBusinessApp post(final MicrosoftStoreForBusinessApp newMicrosoftStoreForBusinessApp) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IMicrosoftStoreForBusinessAppRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IMicrosoftStoreForBusinessAppRequest expand(final String value);

}

