// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IOutlookUserRequest;
import com.microsoft.graph.requests.extensions.IOutlookCategoryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOutlookCategoryRequestBuilder;
import com.microsoft.graph.requests.extensions.IOutlookUserSupportedLanguagesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOutlookUserSupportedTimeZonesCollectionRequestBuilder;
import com.microsoft.graph.models.generated.TimeZoneStandard;
import com.microsoft.graph.requests.extensions.IOutlookUserSupportedTimeZonesCollectionRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Outlook User Request Builder.
 */
public interface IOutlookUserRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IOutlookUserRequest instance
     */
    IOutlookUserRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IOutlookUserRequest instance
     */
    IOutlookUserRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IOutlookCategoryCollectionRequestBuilder masterCategories();

    IOutlookCategoryRequestBuilder masterCategories(final String id);

    IOutlookUserSupportedLanguagesCollectionRequestBuilder supportedLanguages();

    IOutlookUserSupportedTimeZonesCollectionRequestBuilder supportedTimeZones();

    IOutlookUserSupportedTimeZonesCollectionRequestBuilder supportedTimeZones(final TimeZoneStandard timeZoneStandard);

}
