// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IRoleDefinitionRequest;
import com.microsoft.graph.requests.extensions.IRoleAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IRoleAssignmentRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Role Definition Request Builder.
 */
public interface IRoleDefinitionRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IRoleDefinitionRequest instance
     */
    IRoleDefinitionRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IRoleDefinitionRequest instance
     */
    IRoleDefinitionRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IRoleAssignmentCollectionRequestBuilder roleAssignments();

    IRoleAssignmentRequestBuilder roleAssignments(final String id);

}
