// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookTableRequest;
import com.microsoft.graph.requests.extensions.IWorkbookTableColumnCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableColumnRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableRowCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableRowRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableSortRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableClearFiltersRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableConvertToRangeRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableReapplyFiltersRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableDataBodyRangeRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableHeaderRowRangeRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableRangeRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableTotalRowRangeRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Table Request Builder.
 */
public interface IWorkbookTableRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IWorkbookTableRequest instance
     */
    IWorkbookTableRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookTableRequest instance
     */
    IWorkbookTableRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IWorkbookTableColumnCollectionRequestBuilder columns();

    IWorkbookTableColumnRequestBuilder columns(final String id);

    IWorkbookTableRowCollectionRequestBuilder rows();

    IWorkbookTableRowRequestBuilder rows(final String id);

    /**
     * Gets the request builder for WorkbookTableSort
     *
     * @return the IWorkbookTableSortRequestBuilder instance
     */
    IWorkbookTableSortRequestBuilder sort();

    /**
     * Gets the request builder for WorkbookWorksheet
     *
     * @return the IWorkbookWorksheetRequestBuilder instance
     */
    IWorkbookWorksheetRequestBuilder worksheet();
    IWorkbookTableClearFiltersRequestBuilder clearFilters();
    IWorkbookTableConvertToRangeRequestBuilder convertToRange();
    IWorkbookTableReapplyFiltersRequestBuilder reapplyFilters();
    IWorkbookTableDataBodyRangeRequestBuilder dataBodyRange();
    IWorkbookTableHeaderRowRangeRequestBuilder headerRowRange();
    IWorkbookTableRangeRequestBuilder range();
    IWorkbookTableTotalRowRangeRequestBuilder totalRowRange();

}
