// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedDeviceDisableLostModeRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceDisableLostModeRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Disable Lost Mode Request Builder.
 */
public class ManagedDeviceDisableLostModeRequestBuilder extends BaseActionRequestBuilder implements IManagedDeviceDisableLostModeRequestBuilder {

    /**
     * The request builder for this ManagedDeviceDisableLostMode
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceDisableLostModeRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IManagedDeviceDisableLostModeRequest
     *
     * @return the IManagedDeviceDisableLostModeRequest instance
     */
    public IManagedDeviceDisableLostModeRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IManagedDeviceDisableLostModeRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceDisableLostModeRequest instance
     */
    public IManagedDeviceDisableLostModeRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        ManagedDeviceDisableLostModeRequest request = new ManagedDeviceDisableLostModeRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
