// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedMobileAppRequest;
import com.microsoft.graph.requests.extensions.ManagedMobileAppRequest;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Mobile App Request Builder.
 */
public class ManagedMobileAppRequestBuilder extends BaseRequestBuilder implements IManagedMobileAppRequestBuilder {

    /**
     * The request builder for the ManagedMobileApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedMobileAppRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IManagedMobileAppRequest instance
     */
    public IManagedMobileAppRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IManagedMobileAppRequest instance
     */
    public IManagedMobileAppRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ManagedMobileAppRequest(getRequestUrl(), getClient(), requestOptions);
    }


}

