// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IOutlookItemRequest;
import com.microsoft.graph.requests.extensions.OutlookItemRequest;
import com.microsoft.graph.models.extensions.OutlookItem;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Outlook Item Request.
 */
public class OutlookItemRequest extends BaseRequest implements IOutlookItemRequest {
	
    /**
     * The request for the OutlookItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public OutlookItemRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends Option> requestOptions,
            final Class<? extends OutlookItem> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the OutlookItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OutlookItemRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OutlookItem.class);
    }

    /**
     * Gets the OutlookItem from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<OutlookItem> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OutlookItem from the service
     *
     * @return the OutlookItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OutlookItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<OutlookItem> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OutlookItem with a source
     *
     * @param sourceOutlookItem the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final OutlookItem sourceOutlookItem, final ICallback<OutlookItem> callback) {
        send(HttpMethod.PATCH, callback, sourceOutlookItem);
    }

    /**
     * Patches this OutlookItem with a source
     *
     * @param sourceOutlookItem the source object with updates
     * @return the updated OutlookItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OutlookItem patch(final OutlookItem sourceOutlookItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceOutlookItem);
    }

    /**
     * Creates a OutlookItem with a new object
     *
     * @param newOutlookItem the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final OutlookItem newOutlookItem, final ICallback<OutlookItem> callback) {
        send(HttpMethod.POST, callback, newOutlookItem);
    }

    /**
     * Creates a OutlookItem with a new object
     *
     * @param newOutlookItem the new object to create
     * @return the created OutlookItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OutlookItem post(final OutlookItem newOutlookItem) throws ClientException {
        return send(HttpMethod.POST, newOutlookItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IOutlookItemRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (OutlookItemRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IOutlookItemRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (OutlookItemRequest)this;
     }

}

