// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.ISchemaExtensionRequest;
import com.microsoft.graph.requests.extensions.SchemaExtensionRequest;
import com.microsoft.graph.models.extensions.SchemaExtension;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Schema Extension Request.
 */
public class SchemaExtensionRequest extends BaseRequest implements ISchemaExtensionRequest {
	
    /**
     * The request for the SchemaExtension
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SchemaExtensionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SchemaExtension.class);
    }

    /**
     * Gets the SchemaExtension from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<SchemaExtension> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SchemaExtension from the service
     *
     * @return the SchemaExtension from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SchemaExtension get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<SchemaExtension> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SchemaExtension with a source
     *
     * @param sourceSchemaExtension the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final SchemaExtension sourceSchemaExtension, final ICallback<SchemaExtension> callback) {
        send(HttpMethod.PATCH, callback, sourceSchemaExtension);
    }

    /**
     * Patches this SchemaExtension with a source
     *
     * @param sourceSchemaExtension the source object with updates
     * @return the updated SchemaExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SchemaExtension patch(final SchemaExtension sourceSchemaExtension) throws ClientException {
        return send(HttpMethod.PATCH, sourceSchemaExtension);
    }

    /**
     * Creates a SchemaExtension with a new object
     *
     * @param newSchemaExtension the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final SchemaExtension newSchemaExtension, final ICallback<SchemaExtension> callback) {
        send(HttpMethod.POST, callback, newSchemaExtension);
    }

    /**
     * Creates a SchemaExtension with a new object
     *
     * @param newSchemaExtension the new object to create
     * @return the created SchemaExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SchemaExtension post(final SchemaExtension newSchemaExtension) throws ClientException {
        return send(HttpMethod.POST, newSchemaExtension);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ISchemaExtensionRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (SchemaExtensionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ISchemaExtensionRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (SchemaExtensionRequest)this;
     }

}

