// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.ISharedInsightRequest;
import com.microsoft.graph.requests.extensions.SharedInsightRequest;
import com.microsoft.graph.requests.extensions.IEntityWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.EntityWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IEntityWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.EntityWithReferenceRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared Insight Request Builder.
 */
public class SharedInsightRequestBuilder extends BaseRequestBuilder implements ISharedInsightRequestBuilder {

    /**
     * The request builder for the SharedInsight
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SharedInsightRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the ISharedInsightRequest instance
     */
    public ISharedInsightRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ISharedInsightRequest instance
     */
    public ISharedInsightRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new SharedInsightRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for Entity
     *
     * @return the IEntityWithReferenceRequestBuilder instance
     */
    public IEntityWithReferenceRequestBuilder lastSharedMethod() {
        return new EntityWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("lastSharedMethod"), getClient(), null);
    }

    /**
     * Gets the request builder for Entity
     *
     * @return the IEntityWithReferenceRequestBuilder instance
     */
    public IEntityWithReferenceRequestBuilder resource() {
        return new EntityWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("resource"), getClient(), null);
    }
}

