// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams App Collection Request.
 */
public class TeamsAppCollectionRequest extends BaseCollectionRequest<TeamsAppCollectionResponse, ITeamsAppCollectionPage> implements ITeamsAppCollectionRequest {

    /**
     * The request builder for this collection of TeamsApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamsAppCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsAppCollectionResponse.class, ITeamsAppCollectionPage.class);
    }

    public void get(final ICallback<ITeamsAppCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ITeamsAppCollectionPage get() throws ClientException {
        final TeamsAppCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final TeamsApp newTeamsApp, final ICallback<TeamsApp> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new TeamsAppRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newTeamsApp, callback);
    }

    public TeamsApp post(final TeamsApp newTeamsApp) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new TeamsAppRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newTeamsApp);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITeamsAppCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (TeamsAppCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITeamsAppCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (TeamsAppCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ITeamsAppCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (TeamsAppCollectionRequest)this;
    }

    public ITeamsAppCollectionPage buildFromResponse(final TeamsAppCollectionResponse response) {
        final ITeamsAppCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new TeamsAppCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final TeamsAppCollectionPage page = new TeamsAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
