// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams Tab Collection Request.
 */
public class TeamsTabCollectionRequest extends BaseCollectionRequest<TeamsTabCollectionResponse, ITeamsTabCollectionPage> implements ITeamsTabCollectionRequest {

    /**
     * The request builder for this collection of TeamsTab
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamsTabCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsTabCollectionResponse.class, ITeamsTabCollectionPage.class);
    }

    public void get(final ICallback<ITeamsTabCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public ITeamsTabCollectionPage get() throws ClientException {
        final TeamsTabCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final TeamsTab newTeamsTab, final ICallback<TeamsTab> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new TeamsTabRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newTeamsTab, callback);
    }

    public TeamsTab post(final TeamsTab newTeamsTab) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new TeamsTabRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newTeamsTab);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITeamsTabCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (TeamsTabCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITeamsTabCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (TeamsTabCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ITeamsTabCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (TeamsTabCollectionRequest)this;
    }

    public ITeamsTabCollectionPage buildFromResponse(final TeamsTabCollectionResponse response) {
        final ITeamsTabCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new TeamsTabCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final TeamsTabCollectionPage page = new TeamsTabCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
