// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Terms And Conditions Reference Request.
 */
public class TermsAndConditionsReferenceRequest extends BaseRequest implements ITermsAndConditionsReferenceRequest {

    /**
     * The request for the TermsAndConditions
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TermsAndConditionsReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TermsAndConditions.class);
    }

    public void delete(final ICallback<TermsAndConditions> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public TermsAndConditions delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITermsAndConditionsReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (TermsAndConditionsReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITermsAndConditionsReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (TermsAndConditionsReferenceRequest)this;
    }
    /**
     * Puts the TermsAndConditions
     *
     * @param srcTermsAndConditions the TermsAndConditions reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(TermsAndConditions srcTermsAndConditions, final ICallback<TermsAndConditions> callback) {
        send(HttpMethod.PUT, callback, srcTermsAndConditions);
    }

    /**
     * Puts the TermsAndConditions
     *
     * @param srcTermsAndConditions the TermsAndConditions reference to PUT
     * @return the TermsAndConditions
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public TermsAndConditions put(TermsAndConditions srcTermsAndConditions) throws ClientException {
        return send(HttpMethod.PUT, srcTermsAndConditions);
    }
}
