// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookChartPointRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartPointRequest;
import com.microsoft.graph.requests.extensions.IWorkbookChartPointFormatRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartPointFormatRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Point Request Builder.
 */
public class WorkbookChartPointRequestBuilder extends BaseRequestBuilder implements IWorkbookChartPointRequestBuilder {

    /**
     * The request builder for the WorkbookChartPoint
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartPointRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IWorkbookChartPointRequest instance
     */
    public IWorkbookChartPointRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookChartPointRequest instance
     */
    public IWorkbookChartPointRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new WorkbookChartPointRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for WorkbookChartPointFormat
     *
     * @return the IWorkbookChartPointFormatRequestBuilder instance
     */
    public IWorkbookChartPointFormatRequestBuilder format() {
        return new WorkbookChartPointFormatRequestBuilder(getRequestUrlWithAdditionalSegment("format"), getClient(), null);
    }
}

